package ru.yandex.chemodan.app.notifier.metadata;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author bursy
 * Global notification center-specific language. Includes some additional languages missing from Language.
 */
public enum NotifierLanguage implements StringEnum {

    // common languages
    ENGLISH("en"),
    RUSSIAN("ru"),
    UKRAINIAN("uk"),
    TURKISH("tr"),
    // additional GNC languages
    BELARUSIAN("by"),
    KAZAKH("kz"),
    UZBEK("uz");

    private final String value;

    NotifierLanguage(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<NotifierLanguage> R = StringEnumResolver.r(NotifierLanguage.class);

}

