package ru.yandex.chemodan.core.worker;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.RecountCronTask;
import ru.yandex.chemodan.core.worker.tasks.RegenerateDocumentPreview;
import ru.yandex.chemodan.core.worker.tasks.RegenerateImagePreview;
import ru.yandex.chemodan.core.worker.tasks.RegenerateVideoPreview;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetime2;
import ru.yandex.chemodan.core.worker.tasks.ShellOnetimeRpsLimits;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.dynproperties.DynamicPropertyWatcher;

//import ru.yandex.chemodan.app.stat.moderate.ModerationManager;
//import ru.yandex.chemodan.app.stat.worker.ExportVideoDayTop;

/**
 * @author akirakozov
 */
@Configuration
public class ChemodanTasksContextConfiguration {

    @Bean
    public RegenerateVideoPreview regeneratePreviewOnetimeTask(DynamicPropertyManager dynamicPropertyManager) {
        final RegenerateVideoPreview task = new RegenerateVideoPreview();
        dynamicPropertyManager.registerWatcher(task.rpsLimit, new DynamicPropertyWatcher<Integer>() {
            public void updated(Integer integer) {
                task.setRpsLimit(integer);
            }
        });
        return task;
    }

    @Bean
    public RegenerateDocumentPreview regenerateDocumentPreview(DynamicPropertyManager dynamicPropertyManager) {
        final RegenerateDocumentPreview task = new RegenerateDocumentPreview();
        dynamicPropertyManager.registerWatcher(task.rpsLimit, new DynamicPropertyWatcher<Integer>() {
            public void updated(Integer integer) {
                task.setRpsLimit(integer);
            }
        });
        return task;
    }

    @Bean
    public RegenerateImagePreview regenerateImagePreview(DynamicPropertyManager dynamicPropertyManager) {
        final RegenerateImagePreview task = new RegenerateImagePreview();
        dynamicPropertyManager.registerWatcher(task.rpsLimit, new DynamicPropertyWatcher<Integer>() {
            public void updated(Integer integer) {
                task.setRpsLimit(integer);
            }
        });
        return task;
    }

    @Bean
    public RecountCronTask recountCronTask(
            @Value("${worker.recount.period}")
            Duration period,
            @Value("${worker.recount.timeout}")
            Duration timeout)
    {
        return new RecountCronTask(period, timeout);
    }

    @Bean
    public ShellOnetime shellOnetime(
            @Value("${worker.shell-onetime.timeout}")
            Duration timeout)
    {
        return new ShellOnetime(ShellOnetimeRpsLimits.rpsLimit, timeout);
    }

    @Bean
    public ShellOnetime2 shellOnetime2(
            @Value("${worker.shell-onetime2.timeout}")
            Duration timeout)
    {
        return new ShellOnetime2(ShellOnetimeRpsLimits.rpsLimit2, timeout);
    }

    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @Bean
    public Void initShellOnetimeTasks(ShellOnetime shellOnetime, ShellOnetime shellOnetime2) {
        dynamicPropertyManager.addStaticFields(ShellOnetimeRpsLimits.class);

        dynamicPropertyManager.registerAndFireWatcher(ShellOnetimeRpsLimits.rpsLimit, shellOnetime::setRpsLimit);

        dynamicPropertyManager.registerAndFireWatcher(ShellOnetimeRpsLimits.rpsLimit2, shellOnetime2::setRpsLimit);
        return null;
    }
}
