package ru.yandex.chemodan.core.worker.python;

import org.joda.time.Duration;

import ru.yandex.chemodan.ConfigurableTaskUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.io.exec.ShellUtils;

/**
 * @author metal
 */
public class ConfigurableCronTask extends CronTask {
    private static final Duration DEFAULT_TIMEOUT = Duration.standardMinutes(5);

    private final String cronExpression;
    private final String command;
    private final String taskName;
    private final String timeout;

    public ConfigurableCronTask(String cronExpression, String command, String taskName, String timeout) {
        this.cronExpression = cronExpression;
        this.command = command;
        this.taskName = taskName;
        this.timeout = timeout;
    }

    @Override
    public Duration timeout() {
        return ConfigurableTaskUtils.parseTimeout(timeout).getOrElse(DEFAULT_TIMEOUT);
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(
                new ScheduleCron(cronExpression, ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE),
                5);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        ShellUtils.executeInShell(command);
    }

    @Override
    public TaskId id() {
        return new TaskId(taskName);
    }
}
