package ru.yandex.chemodan.core.worker.python;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.spring.ApplicationContextUtils;


/**
 * @author metal
 */
public class CronTasksConfigReader {
    private static final String BEAN_PREFIX = "cronTask";
    private static final String CONFIG_DIRECTORY_PATH = "/etc/mpfs/cron-task-configs";

    public static void registerConfigurableCronTasksFromConfig(ConfigurableApplicationContext applicationContext) {
        ListF<ConfigurableCronTask> cronTasks = readConfigurableTasks();
        for (ConfigurableCronTask cronTask : cronTasks) {
            ApplicationContextUtils.registerSingleton(applicationContext, BEAN_PREFIX + cronTask.id(), cronTask);
        }
    }

    private static ListF<ConfigurableCronTask> readConfigurableTasks() {
        File2 config = new File2(CONFIG_DIRECTORY_PATH);
        ListF<ConfigurableCronTask> cronTasks = Cf.arrayList();
        readConfigurableTasks(config, cronTasks);
        return cronTasks;
    }

    private static void readConfigurableTasks(File2 directoryWithConfigs, ListF<ConfigurableCronTask> cronTasks) {
        for (File2 directory : directoryWithConfigs.listDirectories()) {
            readConfigurableTasks(directory, cronTasks);
        }

        Type type = new TypeToken<List<ConfigurableCronTask>>() {}.getType();
        for (File2 file : directoryWithConfigs.listRegularFiles().filter(f -> f.getExtension().equals("json"))) {
            try {
                cronTasks.addAll(new Gson().<List<ConfigurableCronTask>>fromJson(file.asReaderSource().getInput(), type));
            } catch (IOException e) {
                throw ExceptionUtils.translate(e);
            }
        }
    }
}
