package ru.yandex.chemodan.core.worker.python;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.MpfsShellUtils;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.io.exec.ExecResult;

/**
 * @author metal
 */
public class TrashAutoClean extends CronTask {
    private static final String TRASH_CLEAN_SCRIPT_PATH = "/usr/sbin/mpfs-admin-trash-cleaner-queue-processer.py";
    private static final String CRON_EXPRESSION = "45 1 * * *";

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(
                new ScheduleCron(CRON_EXPRESSION, ru.yandex.misc.time.TimeUtils.EUROPE_MOSCOW_TIME_ZONE),
                50);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        ExecResult execute = MpfsShellUtils.execute(Cf.list(TRASH_CLEAN_SCRIPT_PATH));
    }

}
