package ru.yandex.chemodan.core.worker.python;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.MpfsShellUtils;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author metal
 */
public class TrashClean extends OnetimeTaskSupport<TrashCleanParameters> {
    private static final Logger logger = LoggerFactory.getLogger(TrashClean.class);

    public static final String SCRIPT = "/usr/sbin/mpfs-admin-trash-cleaner.py";

    public TrashClean(TrashCleanParameters parameters) {
        super(parameters);
    }

    public TrashClean() {
        super(TrashCleanParameters.class);
    }

    @Override
    protected void execute(TrashCleanParameters parameters, ExecutionContext executionContext) {
        MpfsShellUtils.execute(Cf.list(SCRIPT, "-s", "-u", parameters.uid));
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(2);
    }
}
