package ru.yandex.chemodan.core.worker.python.onetime;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.MpfsShellUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.concurrent.RpsLimiter;

/**
 * @author Maksim Ahramovich
 */
public class ConfigurableOnetimeTask extends OnetimeTaskSupport<ConfigurableOnetimeTask.Parameters> {
    private final String taskName;
    private final Duration timeout;
    private final String command;
    private final RpsLimiter limiter;

    private final int threadCount;
    private final int queueCount;
    private final int priority;

    public ConfigurableOnetimeTask(
            String taskName,
            Duration timeout,
            String command,
            RpsLimiter limiter,
            int threadCount,
            int queueCount,
            Option<Integer> priorityO
    )
    {
        super(new Parameters(Cf.list()));
        this.taskName = taskName;
        this.timeout = timeout;
        this.command = command;
        this.limiter = limiter;
        this.threadCount = threadCount;
        this.queueCount = queueCount;
        this.priority = priorityO.getOrElse(100);
    }

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public Duration timeout() {
        return timeout;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        ListF<String> commands = Cf.toArrayList(Cf.x(command.split(" ")).filterNot(String::isEmpty));
        if (parameters.commandParameters.isNotEmpty()) {
            commands.addAll(parameters.commandParameters);
        }

        limiter.execute(() -> MpfsShellUtils.execute(commands));
    }

    @Override
    public TaskId id() {
        return new TaskId(taskName);
    }

    @Override
    public TaskQueueName queueName() {
        return new TaskQueueName(taskName);
    }


    @BenderBindAllFields
    public static final class Parameters {
        private final ListF<String> commandParameters;
        Parameters(ListF<String> commandParameters) {
            this.commandParameters = commandParameters;
        }
    }


    public ConfigurableOnetimeTask makeCopy(ListF<String> commandParameters) {
        return makeCopy(new Parameters(commandParameters));
    }

    public ConfigurableOnetimeTask makeCopy(Parameters parameters) {
        ConfigurableOnetimeTask copyTask = new ConfigurableOnetimeTask(taskName, timeout, command,
                limiter, threadCount, queueCount, Option.of(priority));
        copyTask.setParameters(parameters);
        return copyTask;
    }


    public String getTaskName() {
        return taskName;
    }

    public int getQueueCount() {
        return queueCount;
    }

    public int getThreadCount() {
        return threadCount;
    }
}
