package ru.yandex.chemodan.core.worker.python.onetime;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;

/**
 * @author Maksim Ahramovich
 */
public class ConfigurableOnetimeTaskRegistry {

    private ListF<ConfigurableOnetimeTask> tasks = Cf.list();

    @Autowired(required=false)
    public void setTasks(List<ConfigurableOnetimeTask> tasks) {
        this.tasks = Cf.list(tasks);
    }

    public Option<ConfigurableOnetimeTask> getTask(String taskName) {
        return tasks.find(task -> task.getTaskName().equals(taskName));
    }

    public ListF<ConfigurableOnetimeTask> getTasks() {
        return tasks;
    }
}
