package ru.yandex.chemodan.core.worker.tasks;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author akirakozov
 */
@Bendable
public class RegeneratePreviewParameters extends DefaultObject {

    @BenderPart
    public final String uid;
    @BenderPart
    public final String hid;
    @BenderPart
    public final MulcaId mulcaId;
    @BenderPart
    public final String mimeType;
    @BenderPart
    public final long fileSize;
    @BenderPart
    public final String path;
    @BenderPart
    // TODO: make not option after removing old tasks
    public final Option<Instant> mtime;
    @BenderPart
    // TODO: make not option after removing old tasks
    public final Option<Instant> utime;

    public RegeneratePreviewParameters(String uid, String hid, MulcaId mulcaId,
            String mimeType, long fileSize, String path, Instant mtime, Instant utime)
    {
        this.uid = uid;
        this.hid = hid;
        this.mulcaId = mulcaId;
        this.mimeType = mimeType;
        this.fileSize = fileSize;
        this.path = path;
        this.mtime = Option.of(mtime);
        this.utime = Option.of(utime);
    }

    public String getFilename() {
        return getFilenameO().get();
    }

    public Option<String> getFilenameO() {
        return Cf.x(path.split("/")).lastO();
    }

    public RegeneratePreviewParameters withCorrectedMimeType(String correctMimeType) {
        return new RegeneratePreviewParameters(uid, hid, mulcaId, correctMimeType, fileSize, path, mtime.get(),
                utime.get());
    }
}
