package ru.yandex.chemodan.core.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.MpfsShellUtils;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.concurrent.RpsLimiter;
import ru.yandex.misc.thread.ThreadLocalTimeout;

/**
 * @author tolmalev
 */
public class ShellOnetime extends OnetimeTaskSupport<ShellOnetimeParameters> {

    public static final TaskQueueName TASK_QUEUE_NAME = new TaskQueueName("shell-onetime");

    private final RpsLimiter rpsLimiter;
    private final Duration timeout;

    public ShellOnetime(ShellOnetimeParameters parameters) {
        super(parameters);
        rpsLimiter = null;
        timeout = null;
    }

    public ShellOnetime(DynamicProperty<Integer> rpsLimit, Duration timeout) {
        super(ShellOnetimeParameters.class);
        this.timeout = timeout;
        rpsLimiter = new RpsLimiter(rpsLimit.get());
    }

    @Override
    protected void execute(final ShellOnetimeParameters parameters, ExecutionContext context) {
        rpsLimiter.execute(new Function0V() {
            public void apply() {
                ThreadLocalTimeout.Handle tlh = null;
                try {
                    if (parameters.timeoutSeconds.isPresent()) {
                        tlh = ThreadLocalTimeout
                                .push(Duration.standardSeconds(parameters.timeoutSeconds.get()));
                    }
                    MpfsShellUtils.execute(parameters.command);
                } finally {
                    if (tlh != null) {
                        tlh.pop();
                    }
                }
            }
        });
    }

    @Override
    public TaskQueueName queueName() {
        return TASK_QUEUE_NAME;
    }

    public void setRpsLimit(int rpsLimit) {
        rpsLimiter.setRpsLimit(rpsLimit);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return timeout;
    }
}
