package ru.yandex.chemodan.core.worker.tasks.monitoring;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.bazinga.impl.JobStatus;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.impl.controller.TaskStatusStatistics;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Maksim Ahramovich
 */
public abstract class AbstractTaskTriggerCondition extends DefaultObject {
    public final TaskId taskId;

    protected AbstractTaskTriggerCondition(TaskId taskId) {
        this.taskId = taskId;
    }

    public abstract boolean checkCondition(MapF<JobStatus, TaskStatusStatistics> map);

    public abstract AbstractTaskTrigger getTrigger();

    protected double getRps(MapF<JobStatus, TaskStatusStatistics> map, JobStatus status) {
        return map.getO(status).map(s -> s.deltaPerSecond).getOrElse(0d);
    }
}
