package ru.yandex.chemodan.core.worker.tasks.monitoring;

import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.monitoring.arquebus.TriggerSeverity;

/**
 * @author Maksim Ahramovich
 */
public class OnetimeTaskFailedTrigger extends AbstractTaskTrigger {

    public final DynamicProperty<String> failedTriggerSeverity;

    public OnetimeTaskFailedTrigger(TaskId taskId) {
        super(taskId);
        this.failedTriggerSeverity = new DynamicProperty<>("onetimeTask-" + taskId.getId() + "-failed-trigger-severity",
                TriggerSeverity.MEDIUM.name().toLowerCase());
    }

    @Override
    public String description() {
        return "OnetimeTask " + taskId.getId() + " too often falls.";
    }

    @Override
    public TriggerSeverity severity() {
        return TriggerSeverity.R.valueOf(failedTriggerSeverity.get());
    }
}
