package ru.yandex.chemodan.core.worker.tasks.monitoring;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.bazinga.impl.JobStatus;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.impl.controller.TaskStatusStatistics;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author Maksim Ahramovich
 */
public class OnetimeTaskFailedTriggerCondition extends AbstractTaskTriggerCondition {
    public final DynamicProperty<Integer> failedPercent;
    public final DynamicProperty<Double> failedMinRps;
    private OnetimeTaskFailedTrigger trigger;

    public OnetimeTaskFailedTriggerCondition(TaskId taskId) {
        super(taskId);
        this.failedPercent =
                new DynamicProperty<>("onetimeTask-" + taskId.getId() + "-failed-percent", 20);
        this.failedMinRps =
                new DynamicProperty<>("onetimeTask-" + taskId.getId() + "-failed-min-rps", 0.001d);
        trigger = new OnetimeTaskFailedTrigger(taskId);
    }

    private int getFailedPercent() {
        return failedPercent.get();
    }

    private double getFailedMinRps() {
        return failedMinRps.get();
    }


    @Override
    public boolean checkCondition(MapF<JobStatus, TaskStatusStatistics> map) {
        double completedRps = getRps(map, JobStatus.COMPLETED);
        double failedRps = getRps(map, JobStatus.FAILED);

        double rps = completedRps + failedRps;
        int failedPercent = (int) ((100 * failedRps) / (failedRps + completedRps));

        return (rps < getFailedMinRps()) || (failedPercent < getFailedPercent());
    }

    @Override
    public AbstractTaskTrigger getTrigger() {
        return trigger;
    }
}
