package ru.yandex.chemodan.core.worker.tasks.monitoring;

import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.monitoring.arquebus.TriggerSeverity;

/**
 * @author Maksim Ahramovich
 */
public class OnetimeTaskStoppedTrigger extends AbstractTaskTrigger {

    public final DynamicProperty<String> stoppedTriggerSeverity;

    public OnetimeTaskStoppedTrigger(TaskId taskId) {
        super(taskId);
        this.stoppedTriggerSeverity =
                new DynamicProperty<>("onetimeTask-" + taskId.getId() + "-stopped-trigger-severity",
                        TriggerSeverity.MEDIUM.name().toLowerCase());
    }

    @Override
    public String description() {
        return "OnetimeTask " + taskId.getId() + " executing is slowly";
    }

    @Override
    public TriggerSeverity severity() {
        return TriggerSeverity.R.valueOf(stoppedTriggerSeverity.get());
    }
}
