package ru.yandex.chemodan.core.worker.tasks.monitoring;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.bazinga.impl.JobStatus;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.impl.controller.TaskStatusStatistics;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author Maksim Ahramovich
 */
public class OnetimeTaskStoppedTriggerCondition extends AbstractTaskTriggerCondition {
    public final DynamicProperty<Double> stoppedMinRps;
    private OnetimeTaskStoppedTrigger trigger;

    public OnetimeTaskStoppedTriggerCondition(TaskId taskId) {
        super(taskId);
        this.stoppedMinRps =
                new DynamicProperty<>("onetimeTask-" + taskId.getId() + "-stopped-min-rps", 1d);
        this.trigger = new OnetimeTaskStoppedTrigger(taskId);
    }

    private double getStoppedMinRps() {
        return stoppedMinRps.get();
    }


    @Override
    public boolean checkCondition(MapF<JobStatus, TaskStatusStatistics> map) {
        double rps = getRps(map, JobStatus.COMPLETED) + getRps(map, JobStatus.FAILED) + getRps(map, JobStatus.EXPIRED);
        return rps > getStoppedMinRps();
    }

    @Override
    public AbstractTaskTrigger getTrigger() {
        return trigger;
    }
}
