package ru.yandex.chemodan.core.worker.tasks.monitoring;

import java.util.List;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.bazinga.BazingaControllerApp;
import ru.yandex.commune.bazinga.impl.storage.mongo.BazingaMongoDbHolder;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.commune.mail.send.MailSender;
import ru.yandex.commune.mail.sendmail.Sendmail;
import ru.yandex.commune.monitoring.arquebus.ArquebusManager;
import ru.yandex.commune.monitoring.arquebus.TriggerRegistry;
import ru.yandex.commune.monitoring.arquebus.TriggerStateDao;
import ru.yandex.commune.monitoring.arquebus.TriggerStateMongoDao;
import ru.yandex.commune.monitoring.arquebus.admin.ArquebusAdminContextConfiguration;
import ru.yandex.commune.monitoring.arquebus.cronTasks.ArquebusCronTasksContextConfiguration;
import ru.yandex.inside.passport.sms.PassportSmsService;

/**
 * @author Maksim Ahramovich
 */
@Configuration
@Import({
        ArquebusCronTasksContextConfiguration.class,
        ArquebusAdminContextConfiguration.class
})
public class WorkerArquebusContextConfiguration {

    @Bean
    public ArquebusManager arquebusManager(@Value("${worker.onetimetasks.monitoring.subscribers}") String subscribers) {
        ArquebusManager arquebusManager = new ArquebusManager();
        arquebusManager.setDefaultSubscribers(subscribers);
        return arquebusManager;
    }

    @Bean
    public TriggerStateDao triggerStateDao(BazingaMongoDbHolder bazingaMongoDbHolder) {
        return new TriggerStateMongoDao(bazingaMongoDbHolder.getDb());
    }

    @Bean
    public TriggerRegistry triggerRegistry() {
        return new TriggerRegistry();
    }

    @Bean
    public PassportSmsService passportSmsService() {
        return new PassportSmsService();
    }

    @Bean
    public MailSender mailSender() {
        return new Sendmail();
    }

    @Bean
    public TaskStatesMonitor taskStatesMonitor(BazingaControllerApp bazingaControllerApp, List<OnetimeTask> tasks) {
        TaskStatesMonitor taskStatesMonitor = new TaskStatesMonitor(
                bazingaControllerApp.getLockHolder(),
                bazingaControllerApp.getMetrics(),
                Duration.standardMinutes(15),
                bazingaControllerApp.getBazingaTaskStatistics(),
                Cf.toList(tasks)
        );
        bazingaControllerApp.getBazingaController().addControllerStateReactor(taskStatesMonitor);
        return taskStatesMonitor;
    }
}
