package ru.yandex.chemodan.ydb.dao;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author yashunsky
 */
public class YdbPrimitiveStringCompatibleMarshaller extends SimpleTypeMarshallerSupport {
    @Override
    protected String toStringValueForXml(Object o) {
        return getString(o);
    }

    @Override
    protected void writeJson(BenderJsonWriter json, Object o) {
        String value = getString(o);
        if (value == null) {
            json.writeNull();
        } else {
            json.writeString(value);
        }
    }

    private String getString(Object o) {
        return o == null ? null : ((YdbPrimitiveStringCompatible) o).getValue().getString(CharsetUtils.UTF8_CHARSET);
    }
}
