package ru.yandex.chemodan.ydb.dao;

import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.Value;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class YdbQueryMapperTest {

    @Test
    public void trueCondition() {
        YdbQueryMapper.YdbCondition condition = YdbQueryMapper.mapWhereSql(SqlCondition.trueCondition());

        Assert.equals(
                "", condition.declareSql
        );

        Assert.equals(
                "", condition.whereSql
        );

        Assert.isEmpty(condition.params);
    }

    @Test
    public void simpleEq() {
        YdbQueryMapper.YdbCondition condition = YdbQueryMapper.mapWhereSql(SqlCondition.column("aaa").eq(125));

        Assert.equals("DECLARE $params_1 as \"Int32\";\n", condition.declareSql);
        Assert.equals(" WHERE aaa = $params_1", condition.whereSql);

        MapF<String, ? extends Value> params = condition.params;

        Assert.assertListsEqual(Cf.list("$params_1"), params.keys());
        Assert.equals(Cf.set(PrimitiveValue.int32(125)), params.values().unique());
    }
}
