package ru.yandex.chemodan.ydb.dao;

import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.values.StructType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;

/**
 * @author tolmalev
 */
public class YdbTypeUtils {
    public static StructType structTypeFromFields(Tuple2List<String, Type> fieldTypes) {
        return StructType.of(
                fieldTypes.get1(),
                fieldTypes.get2()
        );
    }

    public static StructType structTypeFromFields(TableDescription description) {
        return structTypeFromFields(description, Cf.list());
    }

    public static StructType structTypeFromFields(TableDescription description, ListF<String> optional) {
        return structTypeFromFields(Cf.x(description.getColumns()).toTuple2List(tc -> new Tuple2<>(tc.getName(), tc.getType())));
    }
}
