package ru.yandex.chemodan.ydb.dao.pojo;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.PrimitiveType;
import com.yandex.ydb.table.values.Type;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author yashunsky
 */
public class YdbObjectNode implements BenderJsonNode {
    private final MapF<String, ValueReader> values;

    public YdbObjectNode(MapF<String, ValueReader> values) {
        this.values = values.entries().map1(fieldName -> CamelWords.parse(fieldName).toJavaIdentifier()).toMap();
    }

    @Override
    public Option<BenderJsonNode> getField(String fieldName) {
        return values.getO(fieldName).filterMap(valueReader -> {
            Type valueType = valueReader.getType();
            if (valueType instanceof OptionalType) {
                if (!valueReader.isOptionalItemPresent()) {
                    return Option.empty();
                }
                valueType = valueType.unwrapOptional();
                valueReader = valueReader.getOptionalItem();
            }
            if (valueType instanceof PrimitiveType) {
                PrimitiveType.Id typeId = ((PrimitiveType) valueType).getId();
                if (typeId == PrimitiveType.Id.Json) {
                    return Option.of(BenderParserUtils.json(valueReader.getJson()));
                }
                return Option.of(new YdbValueNode(typeId, valueReader));
            }
            return Option.empty();
        });
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Nonnull
    @Override
    public String getValueAsString() {
        throw new IllegalStateException("Ydb row can not be a value");
    }

    @Nonnull
    @Override
    public String getString() {
        return values.toString();
    }

    @Nullable
    @Override
    public Number getNumberValueOrNull() {
        return null;
    }

    @Override
    public boolean getBooleanValueOrFalse() {
        return false;
    }

    @Override
    public ListF<BenderJsonNode> getArrayElements() {
        return Cf.list();
    }

    @Override
    public ListF<String> getFieldNames() {
        return values.keys();
    }
}
