package ru.yandex.chemodan.ydb.dao.pojo;

import java.util.concurrent.CompletableFuture;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.auth.TokenAuthProvider;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.ydb.dao.ThreadLocalYdbTransactionManager;
import ru.yandex.chemodan.ydb.dao.YdbTimeoutSettings;
import ru.yandex.chemodan.ydb.dao.YdbUtils;
import ru.yandex.devtools.test.Paths;
import ru.yandex.devtools.test.YaTest;
import ru.yandex.misc.io.file.File2;

/**
 * @author yashunsky
 */
public class YdbTestUtils {
    public static <T> void doWithTable(
            Function<ThreadLocalYdbTransactionManager, OneTablePojoYdbDao<T>> initDao,
            Function1V<OneTablePojoYdbDao<T>> action)
    {
        String database;
        String endpoint;

        RpcTransport transport;
        if (YaTest.insideYaTest) {
            endpoint = new File2(Paths.getTestOutputsRoot() + "/ydb_endpoint.txt").readFirstLine();
            database = new File2(Paths.getTestOutputsRoot() + "/ydb_database.txt").readFirstLine();

            transport = GrpcTransport.forEndpoint(endpoint, database).build();
        } else {
            String user = System.getenv("USER");

            endpoint = "ydb-ru-prestable.yandex.net:2135";
            database = "/ru-prestable/home/" + user + "/mydb";

            String token = System.getenv("YDB_TOKEN");
            if (token == null) {
                throw new IllegalStateException("You should set env variable YDB_TOKEN to run tests");
            }
            transport = GrpcTransport.forEndpoint(endpoint, database)
                    .withAuthProvider(new TokenAuthProvider(token))
                    .build();
        }
        try (TableClient tableClient = TableClient.newClient(GrpcTableRpc.ownTransport(transport))
                .sessionPoolSize(10, 100).build())
        {

            YdbTimeoutSettings timeoutSettings = getTestTimeoutSettings();
            ThreadLocalYdbTransactionManager transactionManager = new ThreadLocalYdbTransactionManager(tableClient, timeoutSettings);

            OneTablePojoYdbDao<T> dao = initDao.apply(transactionManager);

            transactionManager.executeInTmpSession((session, tc) -> {
                YdbUtils.dropTableIfExists(database + "/" + dao.getTableName(), session);
                return CompletableFuture.completedFuture(Result.success(null));
            });

            transactionManager.executeInTmpSession((session, tc) -> {
                YdbUtils.createTablesIfMissing(database, session, Cf.list(dao));
                return CompletableFuture.completedFuture(Result.success(null));
            });

            action.apply(dao);

        }
    }

    public static YdbTimeoutSettings getTestTimeoutSettings() {
        return new YdbTimeoutSettings(() -> 5000L, () -> 100L);
    }
}
