package ru.yandex.chemodan.ydb.dao.twin;

import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.util.HostBasedSwitch;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author yashunsky
 */
@Data
public class TwinDaoConfiguration {
    private final TwinDaoMode defaultMode;
    private final int threadsCount;
    private final int queueSize;

    private final DynamicProperty<Long> dynamicFallback;

    private final HostBasedSwitch primary;
    private final HostBasedSwitch async;
    private final HostBasedSwitch secondaryAsync;
    private final HostBasedSwitch secondaryWithFallback;
    private final HostBasedSwitch bothFromPrimary;
    private final HostBasedSwitch bothFromSecondary;
    private final HostBasedSwitch secondary;

    public TwinDaoConfiguration(
            TwinDaoMode defaultMode, int threadsCount, int queueSize, String key)
    {
        this.defaultMode = defaultMode;
        this.threadsCount = threadsCount;
        this.queueSize = queueSize;
        this.primary = new HostBasedSwitch(key + "-twin-dao-primary");
        this.async = new HostBasedSwitch(key + "-twin-dao-async");
        this.secondaryAsync = new HostBasedSwitch(key + "-twin-dao-secondary-async");
        this.secondaryWithFallback = new HostBasedSwitch(key + "-twin-dao-secondary-with-fallback");
        this.bothFromPrimary = new HostBasedSwitch(key + "-twin-dao-both-from-primary");
        this.bothFromSecondary = new HostBasedSwitch(key + "-twin-dao-both-from-secondary");
        this.secondary = new HostBasedSwitch(key + "-twin-dao-secondary");
        this.dynamicFallback = new DynamicProperty<>(key + "-twin-dao-fallback[ms]", 100L);
    }

    public TwinDaoMode getMode() {
        if (primary.get()) {
            return TwinDaoMode.PRIMARY;
        } else if (async.get()) {
            return TwinDaoMode.PRIMARY_W_ASYNC;
        } else if (secondaryAsync.get()) {
            return TwinDaoMode.SECONDARY_W_ASYNC;
        } else if (secondaryWithFallback.get()) {
            return TwinDaoMode.SECONDARY_W_FALLBACK;
        } else if (bothFromPrimary.get()) {
            return TwinDaoMode.BOTH_FROM_PRIMARY;
        } else if (bothFromSecondary.get()) {
            return TwinDaoMode.BOTH_FROM_SECONDARY;
        } else if (secondary.get()) {
            return TwinDaoMode.SECONDARY;
        } else {
            return defaultMode;
        }
    }

    public Duration getFallbackTimeout() {
       return new Duration(dynamicFallback.get());
    }

}
