package ru.yandex.chemodan.ydb.dao.twin;

import java.lang.reflect.Proxy;

import ru.yandex.bolts.function.Function2B;


/**
 * @author yashunsky
 */
public class TwinDaoFactory {
    public static <T> T createProxyDao(Class<T> clazz, T primaryDao, T secondaryDao, TwinDaoConfiguration config,
            Function2B<String, Object> looksSuspiciousF)
    {
        return (T) Proxy.newProxyInstance(
                clazz.getClassLoader(),
                new Class[] { clazz },
                new TwinDaoInvocationHandler<>(primaryDao, secondaryDao,
                        config.getThreadsCount(), config.getQueueSize(), config::getFallbackTimeout, config::getMode,
                        looksSuspiciousF));
    }
}
