import os
import logging
import subprocess

from disk.tasklets.mpfs_release.proto import merge_release_tasklet
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.sdk2 import ssh
from tasklet.services.yav.proto import yav_pb2

MPFS_DIR = 'arcadia'
RELEASE_DIR = 'release'


class MergeReleaseImpl(merge_release_tasklet.MergeReleaseBase):

    def run(self):
        arcadia_mpfs_path = 'disk/mpfs'
        arcadia_url = os.path.join(Arcadia.ARCADIA_TRUNK_URL, arcadia_mpfs_path)
        arcadia_dir = Arcadia.checkout(arcadia_url, MPFS_DIR)
        logging.info("Arcadia is checkouted to %s", arcadia_dir)

        login = self.input.config.login
        ssh_key = self.get_private_ssh_key()
        release_branch = self.input.config.release_branch

        branch_full_name = f"branches/disk/mpfs/releases/{release_branch}"
        release_url = os.path.join(Arcadia.ARCADIA_BASE_URL, branch_full_name)
        release_dir = Arcadia.checkout(release_url, RELEASE_DIR)
        logging.info("Release is checkouted to %s", release_dir)

        initial_commit = Arcadia.log(release_dir, stop_on_copy=True)[-1]['revision']

        subprocess.check_call(['svn',
                               'merge',
                               f'-r{initial_commit}:HEAD',
                               release_dir,
                               arcadia_dir])

        info = Arcadia.status(arcadia_dir)
        if 'Summary of conflicts:' in info:
            raise Exception('Conflicts found, try manual merge')
        logging.info("Info %s", info)

        message = f'__BYPASS_CHECKS__ mpfs: merge {release_branch} into trunk'
        with_revprop = ['arcanum:review-skip=yes', 'arcanum:check-skip=yes']
        with ssh.Key(private_part=ssh_key):
            Arcadia.commit(arcadia_dir, message, user=login, with_revprop=with_revprop)

        self.output.release.msg = 'ok'

    def get_private_ssh_key(self):
        spec = yav_pb2.YavSecretSpec(uuid=self.input.context.secret_uid, key='arcadia_ssh_key')
        return self.ctx.yav.get_secret(spec).secret
