"""
Поиск по debian-репозирорию dist.
"""
import requests

from urlparse import urljoin
from simplejson import JSONDecodeError


class Dist(object):
    base_url = 'http://dist.yandex.ru'

    @classmethod
    def _build_url(cls, url):
        return urljoin(cls.base_url, url)

    @classmethod
    def request(cls, url):
        response = requests.get(url)
        try:
            result = response.json()
        except JSONDecodeError:
            result = None
        return result

    @classmethod
    def find_package(cls, name, version):
        url = 'find?pkg=%s&ver=%s' % (name, version)
        response = cls.request(cls._build_url(url))
        if response:
            return response['result']
        return []


def get_last_disk_release_on_dist(version):
    pkg_name = 'python-mpfs-disk'
    pkgs = Dist.find_package(pkg_name, version)
    release_versions = [pkg_info['version'] for pkg_info in pkgs]

    if release_versions:
        return max(release_versions)
    return None
