#!/bin/sh -e
#
# script for building packages on teamcity
#

exec < /dev/null

ec() {
    echo "$@"
    "$@"
}

err_exit() {
    echo "$@" >&2
    exit 1
}

cd $(dirname $0)

if [ "$1" = --skip-default ]; then
    if $($YANDEX_BUILD/vcs/utils.sh is-default-branch); then
        echo "##teamcity[buildStatus status='FAILURE' text='dont build default branch']"
        echo "don't build default branch"
        exit 0
    fi
fi

vcs_number=$(devel/ya svn --detect log -l 1 | grep ^r | sed 's/^r\([0-9]*\)[^0-9].*/\1/')
component=$(devel/ya svn --detect info | grep '^URL:' | grep -oP '(?<=disk/release_)[^/]+(?=_[0-9.]+)|trunk')

[ -n "$vcs_number" ] || err_exit "failed to get vcs_number"

version="$($YANDEX_BUILD/pkg-build/utils.sh version).$vcs_number"
echo "##teamcity[buildNumber '$component-$version']"

export DEBEMAIL="teamcity@yandex-team.ru"
export DEBFULLNAME="teamcity"

ec dch -v "$version" -b "incver to build debian package"
ec dch -r unstable
ec $YANDEX_BUILD/pkg-build/deb/build.sh -f

for pkg in $($YANDEX_BUILD/pkg-build/deb/utils.sh packages); do
    ec dupload --force --nomail --to ${DUPLOAD_REPO:-common} ../${pkg}_*.changes
done

# vim: set ts=4 sw=4 et:
