package ru.yandex.chemodan.app.tcm.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.tcm.services.ConferenceMetaService;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.chemodan.web.JacksonMapResultSerializer;
import ru.yandex.chemodan.web.JacksonPojoResultSerializer;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.parameter.bind.JacksonParameterBinder;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;

/**
 * @author friendlyevil
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class,
        JacksonContextConfiguration.class,
        ChemodanCommonContextConfiguration.class
})
public class TcmActionContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ""
        ));
    }

    @Bean
    public ConferenceActions conferenceActions(ConferenceMetaService conferenceMetaService) {
        return new ConferenceActions(conferenceMetaService);
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo, ObjectMapper objectMapper) {
        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator
                .getBuilder()
                .addParameterBinders(Cf.list(new JacksonParameterBinder(objectMapper)))
                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
                .addResultSerializers(Cf.list(
                        new JacksonPojoResultSerializer(objectMapper), new JacksonMapResultSerializer(objectMapper)
                ));

        return configurator.configure();
    }
}
