package ru.yandex.chemodan.app.tcm.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.tcm.services.ConferenceMetaManager;
import ru.yandex.chemodan.app.tcm.zk.ShardInfoZkRegistry;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author friendlyevil
 */
@Configuration
public class TcmAdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @Bean
    public TcmShardInfosPage tcmShardInfosPage(ShardInfoZkRegistry shardInfoZkRegistry) {
        TcmShardInfosPage page = new TcmShardInfosPage(shardInfoZkRegistry);
        adminApp.registerAdminPage("shards", Option.of("Tcm"), page);
        return page;
    }

    @Bean
    public TcmSearchPage tcmSearchPage(ConferenceMetaManager conferenceMetaManager) {
        TcmSearchPage page = new TcmSearchPage(conferenceMetaManager);
        adminApp.registerAdminPage("search", Option.of("Tcm"), page);
        return page;
    }
}
