<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="shard-info"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="shard-info">
        <div id="main-content">
            <div class="container">
                <h1>Список шардов</h1>
                <br/>
                <form action="/z/tcm/{shard-id}" method="POST">
                    <div class="form-group row">
                        <label for="shardId" class="col-sm-2 col-form-label">Shard id</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="shardId" type="text" value="{shard-id}"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="balancerHost" class="col-sm-2 col-form-label">Balancer host</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="balancerHost" type="text" value="{balancer-host}"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="fallback" class="col-sm-2 col-form-label">Fallback</label>
                        <div class="col-sm-5">
                            <xsl:choose>
                                <xsl:when test="fallback='true'">
                                    <a class="btn btn-danger" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/fallback/disable">Выключить
                                    </a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a class="btn btn-primary" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/fallback/enable">Включить
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="settleNewExternalConferences" class="col-sm-2 col-form-label">Create new external conference</label>
                        <div class="col-sm-5">
                            <xsl:choose>
                                <xsl:when test="settle-new-external-conferences='true'">
                                    <a class="btn btn-danger" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/settleNewExternalConferences/disable">Выключить
                                    </a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a class="btn btn-primary" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/settleNewExternalConferences/enable">Включить
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="externalConferenceWeight" class="col-sm-2 col-form-label">External conference weight</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="externalConferenceWeight" type="text"
                                   value="{external-conference-weight}"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="settleNewYandexConference" class="col-sm-2 col-form-label">Create new yandex conference</label>
                        <div class="col-sm-5">
                            <xsl:choose>
                                <xsl:when test="settle-new-yandex-conference='true'">
                                    <a class="btn btn-danger" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/settleNewYandexConference/disable">Выключить
                                    </a>
                                </xsl:when>
                                <xsl:otherwise>
                                    <a class="btn btn-primary" onclick="return confirm('Вы уверены?')"
                                       href="/z/tcm/{shard-id}/settleNewYandexConference/enable">Включить
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="yandexConferenceWeight" class="col-sm-2 col-form-label">Yandex conference weight</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="yandexConferenceWeight" type="text"
                                   value="{yandex-conference-weight}"/>
                        </div>
                    </div>

                    <button class="btn btn-primary">Сохранить</button>
                </form>

                <hr/>
                <br/>
                <form action="/z/tcm/delete/{shard-id}" method="POST">
                    <button class="btn btn-danger" onclick="return confirm('Вы уверены?')">Удалить шард</button>
                </form>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
