package ru.yandex.chemodan.app.tcm.admin;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.tcm.db.ConferenceMeta;
import ru.yandex.chemodan.app.tcm.services.ConferenceMetaManager;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author friendlyevil
 */
@ActionContainer
public class TcmSearchPage {
    private final ConferenceMetaManager conferenceMetaManager;

    public TcmSearchPage(ConferenceMetaManager conferenceMetaManager) {
        this.conferenceMetaManager = conferenceMetaManager;
    }

    @ZAction(defaultAction = true, file = "TcmSearchPage.xsl")
    @Path(value = "/tcm/search")
    public ConferenceMetaPojo searchConferenceByShortUrlId(
            @RequestParam(value = "shortUrlId", ignoreEmpty = true, required = false) Option<String> shortUrlId,
            @RequestParam(value = "conferenceId", ignoreEmpty = true, required = false) Option<String> conferenceId) {
        ConferenceQuery query = new ConferenceQuery(shortUrlId, conferenceId);
        if (shortUrlId.isEmpty() && conferenceId.isEmpty()) {
            return new ConferenceMetaPojo(Option.empty(), query);
        }

        Option<ConferenceMeta> conference = conferenceMetaManager.findConference(shortUrlId, conferenceId);
        return new ConferenceMetaPojo(conference, query);
    }


    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ConferenceMetaPojo {
        public final Option<ConferenceMeta> conferenceMeta;
        public final ConferenceQuery query;
    }

    @Data
    @BenderBindAllFields
    @AllArgsConstructor
    private static class ConferenceQuery {
        Option<String> shortUrlId;
        Option<String> conferenceId;
    }
}
