<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <hr/>
                <h3>Найти конференцию</h3>
                <br/>
                <form action="/z/tcm/search/" method="GET">
                    <div class="form-group row">
                        <label for="shortUrlId" class="col-sm-2 col-form-label">Short url id (циферки из ссылки)</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="shortUrlId" type="text" value="{query/short-url-id}"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="conferenceId" class="col-sm-2 col-form-label">Conference id</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="conferenceId" type="text" value="{query/conference-id}"/>
                        </div>
                    </div>
                    <button class="btn btn-primary">Найти</button>
                </form>

                <xsl:apply-templates select="conference-meta"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="conference-meta">
        <br/>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <th>shor url id</th>
                <th>conference id</th>
                <th>shard id</th>
                <th>created at</th>
                <th>expired at</th>
            </tr>
            <tr>
                <td>
                    <xsl:value-of select="short-url-id"/>
                </td>
                <td>
                    <xsl:value-of select="conference-id"/>
                </td>
                <td>
                    <xsl:value-of select="shard-id"/>
                </td>
                <td>
                    <xsl:value-of select="created-at"/>
                </td>
                <td>
                    <xsl:value-of select="expired-at"/>
                </td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>
