package ru.yandex.chemodan.app.tcm.admin;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.tcm.zk.ShardInfo;
import ru.yandex.chemodan.app.tcm.zk.ShardInfoZkRegistry;
import ru.yandex.chemodan.web.EmptyPojo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author friendlyevil
 */
@ActionContainer
public class TcmShardInfosPage {
    private final ShardInfoZkRegistry shardInfoZkRegistry;

    public TcmShardInfosPage(ShardInfoZkRegistry shardInfoZkRegistry) {
        this.shardInfoZkRegistry = shardInfoZkRegistry;
    }

    @ZAction(defaultAction = true, file = "TcmShardInfosPage.xsl")
    @Path("/tcm")
    public ListShardInfosPojo shardInfos() {
        return new ListShardInfosPojo(shardInfoZkRegistry.getAll().toList());
    }

    @Path(value = "/tcm", methods = HttpMethod.POST)
    public EmptyPojo createShard(@RequestParam("shardId") int shardId,
                                 @RequestParam("balancerHost") String balancerHost) {
        ShardInfo shardInfo = ShardInfo.builder()
                .shardId(shardId)
                .balancerHost(balancerHost)
                .settleNewExternalConferences(false)
                .externalConferenceWeight(1.0)
                .settleNewYandexConference(false)
                .yandexConferenceWeight(1.0)
                .build();
        shardInfoZkRegistry.putIfAbsentOrThrow(shardInfo);

        throw new ZRedirectException("/z/tcm");
    }

    @ZAction(file = "TcmEditShardInfoPage.xsl")
    @Path("/tcm/{id}")
    public ShardInfoPojo getShardInfo(@PathParam("id") int shardId) {
        return new ShardInfoPojo(shardInfoZkRegistry.getO(shardId)
                .orElseThrow(() -> new RuntimeException("Shard with id " + shardId + " not found")));
    }

    @Path(value = "/tcm/{id}", methods = HttpMethod.POST)
    public EmptyPojo editShardInfo(@PathParam("id") int id,
                                   @RequestParam("shardId") int shardId,
                                   @RequestParam("balancerHost") String balancerHost,
                                   @RequestParam("externalConferenceWeight") double externalConferenceWeight,
                                   @RequestParam("yandexConferenceWeight") double yandexConferenceWeight) {
        ShardInfo shardInfo = shardInfoZkRegistry.get(id)
                .withShardId(shardId)
                .withBalancerHost(balancerHost)
                .withExternalConferenceWeight(externalConferenceWeight)
                .withYandexConferenceWeight(yandexConferenceWeight);

        if (id != shardId) {
            shardInfoZkRegistry.putIfAbsentOrThrow(shardInfo);
            shardInfoZkRegistry.remove(id);
        } else {
            shardInfoZkRegistry.put(shardInfo);
        }

        throw new ZRedirectException("/z/tcm");
    }

    @Path(value = "/tcm/delete/{id}", methods = HttpMethod.POST)
    public EmptyPojo deleteShardInfo(@PathParam("id") int shardId) {
        shardInfoZkRegistry.remove(shardId);
        throw new ZRedirectException("/z/tcm");
    }

    @Path(value = "/tcm/{id}/fallback/disable")
    public EmptyPojo disableFallback(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withFallback(false));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }

    @Path(value = "/tcm/{id}/fallback/enable")
    public EmptyPojo enableFallback(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withFallback(true));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }

    @Path(value = "/tcm/{id}/settleNewExternalConferences/disable")
    public EmptyPojo disableSettleNewExternalConferences(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withSettleNewExternalConferences(false));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }

    @Path(value = "/tcm/{id}/settleNewExternalConferences/enable")
    public EmptyPojo enableSettleNewExternalConferences(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withSettleNewExternalConferences(true));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }

    @Path(value = "/tcm/{id}/settleNewYandexConference/disable")
    public EmptyPojo disableSettleNewYandexConference(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withSettleNewYandexConference(false));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }

    @Path(value = "/tcm/{id}/settleNewYandexConference/enable")
    public EmptyPojo enableSettleNewYandexConference(@PathParam("id") int shardId) {
        shardInfoZkRegistry.put(shardInfoZkRegistry.get(shardId).withSettleNewYandexConference(true));
        throw new ZRedirectException("/z/tcm/" + shardId);
    }


    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ListShardInfosPojo {
        public final ListF<ShardInfo> shardInfos;
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ShardInfoPojo {
        public final ShardInfo shardInfo;
    }
}
