<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <h1>Список шардов</h1>
                <br/>
                <table class="table table-striped table-condensed table-bordered">
                    <tr>
                        <th>id</th>
                        <th>balancer host</th>
                        <th>is fallback</th>
                        <th>create new external conference</th>
                        <th>external conference weight</th>
                        <th>create new yandex conference</th>
                        <th>yandex conference weight</th>
                        <th>links</th>
                    </tr>
                    <xsl:for-each select="shard-infos">
                        <tr>
                            <td>
                                <xsl:value-of select="shard-id"/>
                            </td>
                            <td>
                                <xsl:value-of select="balancer-host"/>
                            </td>
                            <td>
                                <xsl:call-template name="check-or-not">
                                    <xsl:with-param name="value" select="fallback"/>
                                </xsl:call-template>
                            </td>
                            <td>
                                <xsl:call-template name="check-or-not">
                                    <xsl:with-param name="value" select="settle-new-external-conferences"/>
                                </xsl:call-template>
                            </td>
                            <td>
                                <xsl:value-of select="external-conference-weight"/>
                            </td>
                            <td>
                                <xsl:call-template name="check-or-not">
                                    <xsl:with-param name="value" select="settle-new-yandex-conference"/>
                                </xsl:call-template>
                            </td>
                            <td>
                                <xsl:value-of select="yandex-conference-weight"/>
                            </td>
                            <td>
                                <a href="/z/tcm/{shard-id}">Edit</a><br/>
                                <a href="https://telemost-api.admin.disk.yandex-team.ru/z/telemost-configurations/shard-properties/{shard-id}">Limits</a>
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>

                <hr/>
                <h3>Создать новый шард</h3>
                <br/>
                <form action="/z/tcm" method="POST">
                    <div class="form-group row">
                        <label for="sharId" class="col-sm-2 col-form-label">Shard id</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="shardId" type="text"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="balancerHost" class="col-sm-2 col-form-label">Balancer host</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="balancerHost" type="text"/>
                        </div>
                    </div>
                    <button class="btn btn-primary">Создать шард</button>
                </form>
            </div>
        </div>
    </xsl:template>

    <xsl:template name="check-or-not">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value='true'">
                <svg width="3em" height="3em" viewBox="0 0 16 16" class="bi bi-check2" fill="green" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
                </svg>
            </xsl:when>
            <xsl:otherwise>
                <svg width="3em" height="3em" viewBox="0 0 16 16" class="bi bi-x" fill="red" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" d="M11.854 4.146a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708-.708l7-7a.5.5 0 0 1 .708 0z"/>
                    <path fill-rule="evenodd" d="M4.146 4.146a.5.5 0 0 0 0 .708l7 7a.5.5 0 0 0 .708-.708l-7-7a.5.5 0 0 0-.708 0z"/>
                </svg>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
