package ru.yandex.chemodan.app.tcm.db;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.With;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author friendlyevil
 */
@Getter
@With
@AllArgsConstructor
@NoArgsConstructor
@BenderBindAllFields
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceMeta extends DefaultObject implements JacksonPojo {
    @JsonIgnore
    @BenderIgnore
    UUID id;

    @JsonProperty(value = "short_url_id", required = true)
    String shortUrlId;

    @JsonProperty(value = "conference_id", required = true)
    String conferenceId;

    //@JsonProperty(value = "broadcast_key")
    //Option<String> broadcastKey;

    @JsonProperty(value = "shard_id", required = true)
    int shardId;

    @JsonProperty("expired_at")
    Option<Instant> expiredAt = Option.empty();

    @JsonIgnore
    Instant createdAt;
}
