package ru.yandex.chemodan.app.tcm.db;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author friendlyevil
 */
@Configuration
@Import({JdbcDatabaseConfiguratorContextConfiguration.class, TcmDbContextConfiguration.class})
public class TcmDaoContextConfiguration {
    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    public JdbcDatabaseConfigurator tcmDbConfigurator(DataSourceProperties tcmDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(tcmDataSourceProperties);
    }

    @Bean
    public DataSource tcmDataSource(JdbcDatabaseConfigurator tcmDbConfigurator) {
        return tcmDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 tcmJdbcTemplate(JdbcDatabaseConfigurator tcmDbConfigurator, DataSource tcmDataSource) {
        return tcmDbConfigurator.consTemplate(tcmDataSource);
    }

    @Bean
    public ConferenceMetaDao conferenceMetaDao(JdbcTemplate3 tcmJdbcTemplate) {
        return new ConferenceMetaDao(tcmJdbcTemplate);
    }
}
