package ru.yandex.chemodan.app.tcm.db;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author friendlyevil
 */
@Configuration
@ConditionalOnMissingEmbeddedDb
public class TcmDbContextConfiguration {

    @Bean
    @OverridableValuePrefix("tcm")
    public DataSourceProperties tcmDataSourceProperties() {
        return new DataSourceProperties();
    }
}
