package ru.yandex.chemodan.app.tcm.services;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.tcm.actions.CreateConferenceSettings;
import ru.yandex.chemodan.app.tcm.db.ConferenceMeta;
import ru.yandex.chemodan.app.tcm.zk.ShardInfo;

/**
 * @author friendlyevil
 */
public class ConferenceMetaService {
    private final ConferenceMetaManager conferenceMetaManager;
    private final ShardResolver shardResolver;

    public ConferenceMetaService(ConferenceMetaManager conferenceMetaManager, ShardResolver shardResolver) {
        this.conferenceMetaManager = conferenceMetaManager;
        this.shardResolver = shardResolver;
    }

    public ShardInfo getShardInfo(Option<String> shortUrlId, Option<String> conferenceId) {
        return getSharInfo(shortUrlId, conferenceId);
    }

    public void saveConferenceMeta(ConferenceMeta conferenceMeta) {
        conferenceMetaManager.createConferenceMeta(conferenceMeta);
    }

    public void updateConferenceMeta(ConferenceMeta conferenceMeta) {
        conferenceMetaManager.updateConferenceMeta(conferenceMeta);
    }

    public ShardInfo getShardForNewConference(CreateConferenceSettings settings) {
        return shardResolver.getShardForNewConference(settings);
    }

    public ShardInfo getShardForUserInfo(CreateConferenceSettings settings) {
        return shardResolver.getShardForUserInfo(settings);
    }

    private ShardInfo getSharInfo(Option<String> shortUrlId, Option<String> conferenceId) {
        Option<ConferenceMeta> conference = conferenceMetaManager.findConference(shortUrlId, conferenceId);
        if (conference.isPresent()) {
            return shardResolver.getShardInfoById(conference.get().getShardId());
        }

        return shardResolver.getFallbackShard();
    }
}
