package ru.yandex.chemodan.app.tcm.services;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.tcm.db.ConferenceMetaDao;
import ru.yandex.chemodan.app.tcm.db.TcmDaoContextConfiguration;
import ru.yandex.chemodan.app.tcm.zk.ShardInfoZkRegistry;
import ru.yandex.chemodan.app.tcm.zk.TcmShardInfoZkConfiguration;

/**
 * @author friendlyevil
 */
@Configuration
@Import({TcmDaoContextConfiguration.class, TcmShardInfoZkConfiguration.class})
public class ConferenceServiceContextConfiguration {

    @Bean
    public ConferenceMetaManager conferenceMetaManager(ConferenceMetaDao conferenceMetaDao) {
        return new ConferenceMetaManager(conferenceMetaDao);
    }

    @Bean
    public ConferenceMetaService conferenceMetaService(ConferenceMetaManager conferenceMetaManager,
                                                       ShardResolver shardResolver) {
        return new ConferenceMetaService(conferenceMetaManager, shardResolver);
    }

    @Bean
    public ShardResolver shardResolver(ShardInfoZkRegistry shardInfoZkRegistry) {
        return new ShardResolver(shardInfoZkRegistry);
    }
}
