package ru.yandex.chemodan.app.tcm.zk;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;

/**
 * @author friendlyevil
 */
public class ShardInfoZkRegistry extends ZkRegistry<Integer, ShardInfo> {
    public ShardInfoZkRegistry(ZkPath zkPath) {
        super(zkPath, Bender.cons(ShardInfo.class), ShardInfo::getShardId, id -> Integer.toString(id));
    }

    public void putIfAbsentOrThrow(ShardInfo shardInfo) {
        if (getO(shardInfo.getShardId()).isPresent()) {
            throw new IllegalArgumentException("Shard with id " + shardInfo.getShardId() + " already exist");
        }

        put(shardInfo);
    }
}
