package ru.yandex.chemodan.app.tcm.zk;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author friendlyevil
 */
@Configuration
public class TcmShardInfoZkConfiguration {
    @Autowired
    private ZkManager zkManager;

    @Autowired
    private ZkPath zkRoot;

    @Bean
    public ShardInfoZkRegistry shardInfoZkRegistry() {
        ShardInfoZkRegistry registry = new ShardInfoZkRegistry(zkRoot.child("tcm").child("shards"));
        zkManager.addClient(registry);
        return registry;
    }
}
