package ru.yandex.chemodan.app.telemost;

import java.io.Serializable;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.layout.PatternLayout;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.config.TelemostConfiguration;
import ru.yandex.chemodan.app.telemost.config.common.TelemostAdminDaemonContextConfiguration;
import ru.yandex.chemodan.app.telemost.logging.TelemostAccessLog;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.log.TskvLogPatternLayout;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

public class TelemostMain extends ChemodanMainSupport {

    private static Layout<? extends Serializable> requestsLayout(AppName applicationName, Option<String> name) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-" + applicationName.appName() + "-requests-log"
                + "\tappname="+applicationName.appName()
                + "\thost=" + HostnameUtils.localHostname()
                + "\tclass=%c"
                + "\tname=" + name.getOrElse("%tskvX{name}")
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\tlevel=%level"
                + "\trequest_id=%rid"
                + TskvLogPatternLayout.logEnvironment()
                + "\tmessage=%tskvm%tskvex%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static Layout<? extends Serializable> defaultLayout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-" + applicationName.appName() + "-default-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=telemost-backend.default"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\trequest_id=%rid"
                + "\tpid=%t"
                + "\tmodule=%c"
                + "\tlevel=%level"
                + "\tmessage=%tskvm%tskvex%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static Layout<? extends Serializable> errorLayout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-" + applicationName.appName() + "-error-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=telemost-backend.error"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\trequest_id=%rid"
                + "\tpid=%t"
                + "\tmodule=%c"
                + "\tlevel=%level"
                + "\tmessage=%tskvm%tskvex{short}%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static void main(String[] args) {
        new TelemostMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("telemost", "telemost-backend");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(TelemostConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        PluginManager.addPackage("ru.yandex.chemodan.log.plugins");

        Log4jHelper.rootLoggerBuilder().appName(applicationName()).miscLevel(Level.INFO).postfix("-default")
                .measureExceptions(false)
                .layout(defaultLayout(applicationName())).build();

        Log4jHelper.accessLoggerBuilder().appName(applicationName())
                .layout(TelemostAccessLog.accessLayout(applicationName())).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.DEBUG).name("requests")
                .layout(requestsLayout(applicationName(), Option.of("pg"))).postfix("-requests").buffSize(1024*1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO)
                .name("ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4Utils")
                .layout(requestsLayout(applicationName(), Option.empty()))
                .postfix("-requests").buffSize(1024 * 1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO)
                .name("ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4")
                .layout(requestsLayout(applicationName(), Option.empty()))
                .postfix("-requests").buffSize(1024 * 1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO)
                .name("ru.yandex.chemodan.grpc.client.LoggingGrpcInterceptor")
                .layout(requestsLayout(applicationName(), Option.of("gRPC")))
                .postfix("-requests").buffSize(1024 * 1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO).name("error")
                .layout(errorLayout(applicationName())).postfix("-error").build();
    }

    @Override
    protected Class<?> getAdminDaemonContextConfiguration() {
        return TelemostAdminDaemonContextConfiguration.class;
    }
}
