<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="configuration"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="configuration">
        <h1>Редактирование конфигурации</h1>
        <br/>
        <form action="/z/telemost-configurations/add-configuration" method="POST">
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Комментарий</label>
                <div class="col-sm-5">
                    <input class="form-control" name="comment" type="text" value="{comment}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="value" class="col-sm-2 col-form-label">JSON-конфигурация</label>
                <div class="col-sm-5">
                    <textarea class="form-control" name="value" type="text" rows="20">
                        <xsl:value-of select="value"/>
                    </textarea>
                </div>
            </div>
            <button class="btn btn-primary" onclick="return confirm('Вы уверены?')">Сохранить</button>
        </form>
        <hr/>
    </xsl:template>
</xsl:stylesheet>
