package ru.yandex.chemodan.app.telemost.admin;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.exceptions.TelemostRuntimeException;
import ru.yandex.chemodan.app.telemost.services.ClientConfigurationService;
import ru.yandex.chemodan.app.telemost.services.model.AdminClientConfiguration;
import ru.yandex.chemodan.util.auth.YateamAuthUtils;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@ActionContainer
public class ClientConfigurationAdminPage {

    private final ClientConfigurationService clientConfigurationService;

    public ClientConfigurationAdminPage(ClientConfigurationService clientConfigurationService) {
        this.clientConfigurationService = clientConfigurationService;
    }

    @ZAction(defaultAction = true, file = "edit_configuration.xsl")
    @Path("/telemost-configurations/actual-configuration")
    public Content getActualConfiguration() {
        return new Content(clientConfigurationService.getFormattedActualClientConfiguration());
    }

    @Path(value = "/telemost-configurations/add-configuration", methods = HttpMethod.POST)
    public void addNewConfiguration(
            @RequestParam("value") String value,
            @RequestParam("comment") String comment,
            @SpecialParam HttpServletRequestX reqX
    ) {
        Option<String> loginO = YateamAuthUtils.getLoginFromAttributeO(reqX);
        String login;
        if (EnvironmentType.getActive() != EnvironmentType.PRODUCTION &&
                EnvironmentType.getActive() != EnvironmentType.PRESTABLE &&
                EnvironmentType.getActive() != EnvironmentType.QA) {
            login = "testUser";
        } else {
            login = loginO.getOrThrow(() -> new TelemostRuntimeException("No Ya Team login"));
        }
        clientConfigurationService.addNewClientConfiguration(value, login, Option.ofNullable(comment)
                .filter(StringUtils::isNotBlank));
        throw new ZRedirectException("/telemost-configurations/actual-configuration");
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    public static class Content {
        private final AdminClientConfiguration configuration;
    }
}
