package ru.yandex.chemodan.app.telemost.admin;

import lombok.Data;

import ru.yandex.chemodan.app.telemost.common.ShardProperties;
import ru.yandex.chemodan.app.telemost.common.ShardPropertiesZkRegistry;
import ru.yandex.chemodan.web.EmptyPojo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;

@ActionContainer
public class ShardPropertiesPage {
    private final ShardPropertiesZkRegistry shardPropertiesZkRegistry;

    public ShardPropertiesPage(ShardPropertiesZkRegistry shardInfoZkRegistry) {
        this.shardPropertiesZkRegistry = shardInfoZkRegistry;
    }

    @ZAction(defaultAction = true)
    @Path("/telemost-configurations/shard-properties/")
    public EmptyPojo shardPropertiesCurrent() {
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + shardPropertiesZkRegistry.get().getShardId());
    }

    @ZAction(file = "ShardPropertiesPage.xsl")
    @Path("/telemost-configurations/shard-properties/{id}")
    public ShardPropertiesPojo shardProperties(@PathParam("id") int shardId) {
        return new ShardPropertiesPojo(shardPropertiesZkRegistry.get(shardId));
    }

    @Path(value = "/telemost-configurations/shard-properties/{id}/autoCalcCurrentParticipants/disable")
    public EmptyPojo autoCalcCurrentParticipantsDisable(@PathParam("id") int shardId) {
        ShardProperties properties = shardPropertiesZkRegistry.get(shardId);
        properties.setAutoCalcCurrentParticipants(false);
        shardPropertiesZkRegistry.put(properties);
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + properties.getShardId());
    }

    @Path(value = "/telemost-configurations/shard-properties/{id}/autoCalcCurrentParticipants/enable")
    public EmptyPojo autoCalcCurrentParticipantsEnable(@PathParam("id") int shardId) {
        ShardProperties properties = shardPropertiesZkRegistry.get(shardId);
        properties.setAutoCalcCurrentParticipants(true);
        shardPropertiesZkRegistry.put(properties);
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + properties.getShardId());
    }

    @Path(value = "/telemost-configurations/shard-properties/{id}/checkOverload/disable")
    public EmptyPojo checkOverloadDisable(@PathParam("id") int shardId) {
        ShardProperties properties = shardPropertiesZkRegistry.get(shardId);
        properties.setCheckOverload(false);
        shardPropertiesZkRegistry.put(properties);
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + properties.getShardId());
    }

    @Path(value = "/telemost-configurations/shard-properties/{id}/checkOverload/enable")
    public EmptyPojo checkOverloadEnable(@PathParam("id") int shardId) {
        ShardProperties properties = shardPropertiesZkRegistry.get(shardId);
        properties.setCheckOverload(true);
        shardPropertiesZkRegistry.put(properties);
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + properties.getShardId());
    }

    @Path(value = "/telemost-configurations/shard-properties/{id}", methods = HttpMethod.POST)
    public EmptyPojo editShardInfo(@PathParam("id") int shardId,
                                   @RequestParam("currentParticipants") int currentParticipants,
                                   @RequestParam("maxParticipants") int maxParticipants) {
        ShardProperties properties = shardPropertiesZkRegistry.get(shardId);
        if (!properties.isAutoCalcCurrentParticipants()) {
            properties.setCurrentParticipants(currentParticipants);
        }
        properties.setMaxParticipants(maxParticipants);
        shardPropertiesZkRegistry.put(properties);
        throw new ZRedirectException("/telemost-configurations/shard-properties/" + properties.getShardId());
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ShardPropertiesPojo {
        public final ShardProperties configuration;
    }
}
