<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="configuration"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="configuration">
        <h1>Редактирование настроек шарда</h1>
        <br/>
        <form action="/z/telemost-configurations/shard-properties/{shard-id}" method="POST">
            <div class="form-group row">
                <label for="shardId" class="col-sm-2 col-form-label">ID шарда</label>
                <div class="col-sm-5">
                    <input class="form-control" name="shardId" type="text" value="{shard-id}" disabled=""/>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Лимитирование по количеству пиров</label>
                <div class="col-sm-5">
                    <xsl:choose>
                        <xsl:when test="check-overload='true'">
                            <a class="btn btn-danger" onclick="return confirm('Вы уверены?')"
                               href="/z/telemost-configurations/shard-properties/{shard-id}/checkOverload/disable">Выключить
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <a class="btn btn-primary" onclick="return confirm('Вы уверены?')"
                               href="/z/telemost-configurations/shard-properties/{shard-id}/checkOverload/enable">Включить
                            </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Автоматическое определение количества пиров
                </label>
                <div class="col-sm-5">
                    <xsl:choose>
                        <xsl:when test="auto-calc-current-participants='true'">
                            <a class="btn btn-danger" onclick="return confirm('Вы уверены?')"
                               href="/z/telemost-configurations/shard-properties/{shard-id}/autoCalcCurrentParticipants/disable">Выключить
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <a class="btn btn-primary" onclick="return confirm('Вы уверены?')"
                               href="/z/telemost-configurations/shard-properties/{shard-id}/autoCalcCurrentParticipants/enable">Включить
                            </a>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Текущее количество пиров</label>
                <div class="col-sm-5">
                    <xsl:choose>
                        <xsl:when test="auto-calc-current-participants='true'">
                            <input class="form-control" name="currentParticipants" type="text"
                                   value="{current-participants}" disabled=""/>
                        </xsl:when>
                        <xsl:otherwise>
                            <input class="form-control" name="currentParticipants" type="text"
                                   value="{current-participants}"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Максимальное количество пиров</label>
                <div class="col-sm-5">
                    <input class="form-control" name="maxParticipants" type="text" value="{max-participants}"/>
                </div>
            </div>
            <button class="btn btn-primary" onclick="return confirm('Вы уверены?')">Сохранить</button>
        </form>
        <hr/>
    </xsl:template>

</xsl:stylesheet>
