package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.chemodan.app.telemost.services.model.ChatType;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
public class ChatCreated extends DefaultObject implements AppMessage {
    public static final String TYPE = "chat_created";

    @JsonProperty("chat_type")
    ChatType chatType;

    @JsonProperty("chat_path")
    String chatPath;

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
