package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.services.model.ConferenceState;
import ru.yandex.chemodan.app.telemost.web.v2.model.ConferenceStateData;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
public class ConferenceStateResponse extends DefaultObject {
    @JsonProperty("version")
    private long version;

    @JsonProperty("state")
    private ConferenceStateData state;

    public ConferenceStateResponse(ConferenceState state) {
        this.version = state.getVersion();
        this.state = new ConferenceStateData(state);
    }
}
