package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@NoArgsConstructor
@AllArgsConstructor
public class GetPeersStateRequest extends DefaultObject implements AppMessage {
    public static final String TYPE = "peers_state_get";

    @JsonProperty("peers")
    private ListF<GetPeerStateRequest> peersState;

    @JsonProperty("conference")
    private GetConferenceStateRequest conferenceState;

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
