package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.repository.model.UserStateDto;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
public class PeerState extends DefaultObject {
    @JsonProperty("peer_id")
    private String peerId;
    @JsonProperty("version")
    private long version;
    @JsonProperty("state")
    private JsonNode state;

    public PeerState(String peerId, UserStateDto state) {
        this.peerId = peerId;
        this.version = state.getVersion();
        this.state = state.getState();
    }
}
