package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
public class PeersState extends DefaultObject implements AppMessage {
    public static final String TYPE = "peers_state";

    @JsonProperty("peers")
    private ListF<PeerState> peers;

    @JsonProperty("conference")
    private Option<ConferenceStateResponse> conference;

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
